/*
	DevSaver Web Framework
	Copyright (c) 2013-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com				
*/

var STBWidgetCountDown = Object.create(STBModule.prototype);

STBWidgetCountDown.name = "WidgetCountDown";
STBWidgetCountDown.initPlugin = function() {

   var elements = $(".countdown-classic:not(.__done)");

   if (elements.length) {

		var template = function (days, hours, minutes, seconds) {

			return '<div class="col-md-3 col-sm-3 col-6">	\
							<div class="counter-element">	\
								<div class="content">	\
									<span class="milestone-count">%-D</span>	\
									<h3 class="milestone-detail">' + days + '</h3>	\
								</div>	\
								<span class="right-line"></span>	\
							</div>	\
						</div>	\
						<div class="col-md-3 col-sm-3 col-6">	\
							<div class="counter-element">	\
								<div class="content">	\
									<span class="milestone-count">%H</span>	\
									<h3 class="milestone-detail">' + hours + '</h3>	\
								</div>	\
								<span class="right-line"></span>	\
							</div>	\
						</div>	\
						<div class="col-md-3 col-sm-3 col-6">	\
							<div class="counter-element">	\
								<div class="content">	\
									<span class="milestone-count">%M</span>	\
									<h3 class="milestone-detail">' + minutes + '</h3>	\
								</div>	\
								<span class="right-line"></span>	\
							</div>	\
						</div>	\
						<div class="col-md-3 col-sm-3 col-6">	\
							<div class="counter-element">	\
								<div class="content">	\
									<span class="milestone-count">%S</span>	\
									<h3 class="milestone-detail">' + seconds + '</h3>	\
								</div>	\
								<span class="right-line"></span>	\
							</div>	\
						</div>';
		};


	   elements.each(function () {
			var obj		= $(this),
				date	= obj.attr("data-date"),
				days	= obj.attr("data-lang-days"),
				hours	= obj.attr("data-lang-hours"),
				minutes = obj.attr("data-lang-minutes"),
				seconds = obj.attr("data-lang-seconds");

			obj.countdown(date).on(
				"update.countdown",
				function (event) {
					$(this).html(event.strftime(
						template(days, hours, minutes, seconds)
					));
				}
			);

			obj.addClass("__done");
		});

   }
}


STBWidgetCountDown.runOnReady = function() {
	STBWidgetCountDown.initPlugin();
}

STBWidgetCountDown.runOnContentUpdate = function() {
	STBWidgetCountDown.initPlugin();
}

site.registerModule(STBWidgetCountDown);